/**
* \file: LibraryEntryPoint.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto - Media Browser
*
* \author: K. Kuroda / ADITJ/SW / kkuroda@jp.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <adit_logging.h>
#include <aauto/AditEndpointCommon.h>
#include "DummyMediaBrowserSource.h"

LOG_DECLARE_CONTEXT(aauto_media_browser);

using namespace adit::aauto;

#ifndef COMP_GIT_VERSION
#define COMP_GIT_VERSION "aauto_r3_d01 or newer"
#endif

AditMediaBrowser* DummyMediaBrowserSourceCreate(uint8_t inId,
        MessageRouter* inRouter)
{
    if(inRouter == nullptr)
    {
        LOG_ERROR((aauto_media_browser, "MessageRouter pointer is null"));
        return nullptr;
    }

    return new DummyMediaBrowserSource(inId, inRouter);
}

/*
 * In case the library is linked at compile time it is more convenient to call
 * unique functions rather than the generic plug-in versions.
 */

void DummyMediaBrowserEntryPoint(FactoryRegisterFn inFactoryRegisterFn)
{
    LOG_REGISTER_CONTEXT(aauto_media_browser, "TMBS", "AAUTO Media Browser");
    LOGD_DEBUG((aauto_media_browser, "aauto-test-media-browser git tag: %s", COMP_GIT_VERSION));

    if (inFactoryRegisterFn != nullptr)
    {
        // it is not required to use the factory
        inFactoryRegisterFn("DummyMediaBrowser",
                FactoryMediaBrowser,
                (CreatorFn)DummyMediaBrowserSourceCreate);
    }
}

void DummyMediaBrowserExitPoint()
{
    LOG_UNREGISTER_CONTEXT(aauto_media_browser);
}

extern "C" void aauto_LibraryEntryPoint(FactoryRegisterFn inFactoryRegisterFn)
{
    DummyMediaBrowserEntryPoint(inFactoryRegisterFn);
}

extern "C" void aauto_LibraryExitPoint()
{
    DummyMediaBrowserExitPoint();
}
